package jamezo97.clonecraft.network;

import jamezo97.clonecraft.entity.clone.EntityClone;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;

public abstract class Handler {
	
	
	FieldValue[] fields = null;
	/***
	 * Gets all the declared fields which have been annotated with the "Value" annotation. Returns it as a FieldValue array.
	 * @return
	 */
	private FieldValue[] getFields(){
		if(fields == null){
			Field[] allFields = getClass().getDeclaredFields();
			ArrayList<FieldValue> fieldValues = new ArrayList<FieldValue>();
			for(int a = 0; a < allFields.length; a++){
				Value val = allFields[a].getAnnotation(Value.class);
				if(val != null){
					fieldValues.add(new FieldValue(allFields[a], this, val.id()));
				}
			}
			fields = fieldValues.toArray(new FieldValue[fieldValues.size()]);
		}
		return fields;
	}
	
	public void sendToClients(EntityPlayer... players){
		Packet packet = createPacket(Side.CLIENT);
		if(players != null){
			for(int a = 0; a < players.length; a++){
				NetworkHandler.sendPacketToPlayers(players, packet);
			}
		}
	}
	
	public void sendToClientsExcluding(EntityPlayer excluding, EntityPlayer... players){
		Packet packet = createPacket(Side.CLIENT);
		if(players != null){
			for(int a = 0; a < players.length; a++){
				if(players[a] != excluding){
					NetworkHandler.sendPacketToPlayer(packet, (Player)players[a]);
				}
			}
		}
	}
	
	
	/***
	 * Send this handler to the player.
	 * @param player The player to send the handler to.
	 */
	public void sendToClient(EntityPlayer player){
		NetworkHandler.sendPacketToPlayer(createPacket(Side.CLIENT), (Player)player);
	}
	
	/***
	 * Send the handler to the server.
	 */
	public void sendToServer(){
		NetworkHandler.sendPacketToServer(createPacket(Side.SERVER));
	}

	public boolean sendToAllWatching(Entity entity){
		if(entity != null){
			return NetworkHandler.sendPacketToPlayersWatching(entity, createPacket(Side.CLIENT));
		}
		return false;
	}
	
	public boolean sendToAllWatchingIncluding(EntityPlayer entity){
		if(entity != null){
			Packet p = createPacket(Side.CLIENT);
			NetworkHandler.sendPacketToPlayer(p, (Player)entity);
			return NetworkHandler.sendPacketToPlayersWatching(entity, p);
		}
		return false;
	}
	
	public boolean sendToWatchingPlayersExcluding(Entity entity, EntityPlayer excluding){
		if(entity != null){
			return NetworkHandler.sendPacketToPlayersWatchingExcluding(entity, createPacket(Side.CLIENT), excluding);
		}
		return false;
	}
	

	public void sendToAllNear(int x, int y, int z, int dimension, int radius) {
		NetworkHandler.sendPacketToAllAround(x, y, z, radius, dimension, createPacket(Side.CLIENT));
	}
	
/*private Packet250CustomPayload pastPacket;
	
	*//***
	 * Create a packet from this handler to send.
	 * @param sideToSendTo The side which this handler is destined for.
	 * @return
	 *//*
	public Packet250CustomPayload createPacket(Side sideToSendTo){
		if(pastPacket == null){
			pastPacket = new Packet250CustomPayload( (sideToSendTo==Side.CLIENT?"CloneCraftClient":"CloneCraftServer"), getBytes());
		}
		return pastPacket;
	}*/
	
	/***
	 * Create a packet from this handler to send.
	 * @param sideToSendTo The side which this handler is destined for.
	 * @return
	 */
	public Packet250CustomPayload createPacket(Side sideToSendTo){
		Packet250CustomPayload packet = new Packet250CustomPayload( (sideToSendTo==Side.CLIENT?"CloneCraftClient":"CloneCraftServer"), getBytes());
		return packet;
	}

	/***
	 * Called once the packet has reached it's destination and has been unpacked.
	 * @param side The side it has arrived on.
	 * @param manager The network manager for the side.
	 * @param player The player it has either been sent from, or to, dependent on the side.
	 */
	public abstract void handle(Side side, INetworkManager manager, EntityPlayer player);
	
	/***
	 * Gets the ID of the handler, as assigned below in the static section.
	 * @return
	 */
	public final int getId(){
		return ((Integer)classToId.get(getClass())).intValue();
	}
	
	/***
	 * Creates an array of bytes representing this handler, to be sent via Packet250CustomPayload.
	 * @return
	 */
	private byte[] getBytes(){
		FieldValue[] values = getFields();
		ByteArrayOutputStream byteOut = null;
		DataOutputStream out = null;
		try{
			byteOut = new ByteArrayOutputStream();
			out = new DataOutputStream(byteOut);
			//Write the id for this handler.
			out.write(getId());
			if(values != null){
				for(int a = 0; a < values.length; a++){
					values[a].write(out);
				}
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			if(out != null){
				try{
					out.close();
				}catch(Exception e){
					e.printStackTrace();
				}
			}
			if(byteOut != null){
				return byteOut.toByteArray();
			}
		}
		return null;
	}
	
	/***
	 * From the stream(which is created thought a ByteArrayReader from the data given in a Packet250CustomPayload
	 * , it reads all the values which were set in the method getBytes(), and sets the declared fields to the sent value...
	 * @param in The DataInputStream to read the data from.
	 * @return Returns true if successful.
	 * @throws Exception If an error occurs.
	 */
	public boolean fillData(DataInputStream in)throws Exception{
		FieldValue[] values = getFields();
		if(values != null){
			if(values.length == 0){
				return true;
			}
			while(in.available() > 0){
				int id = in.read();
				for(int a = 0; a < values.length; a++){
					if(values[a].id == id){
						values[a].read(in);
						break; 
					}
				}
			}
			return true;
		}
		return false;
	}
	
	public static EntityClone getCloneOnSide(Side side, int entityId, int worldId){
		if(side == Side.CLIENT){
			return getCloneOnClient(entityId);
		}else if(side == Side.SERVER){
			return getCloneOnServer(entityId, worldId);
		}
		return null;
	}
	
	public static Entity getEntityOnSide(Side side, int entityId, int worldId){
		if(side == Side.CLIENT){
			return getEntityOnClient(entityId);
		}else if(side == Side.SERVER){
			return getEntityOnServer(entityId, worldId);
		}
		return null;
	}
	
	public static EntityClone getCloneOnServer(int entityId, int worldId){
		World world = MinecraftServer.getServer().worldServerForDimension(worldId);
		if(world != null){
			return getCloneOnServer(entityId, world);
		}
		return null;
	}

	public static EntityClone getCloneOnServer(int entityId, World world){
		if(world != null){
			Entity e = world.getEntityByID(entityId);
			if(e != null && e instanceof EntityClone){
				return (EntityClone)e;
			}
		}
		return null;
	}
	
	public static Entity getEntityOnServer(int entityId, int worldId){
		World world = MinecraftServer.getServer().worldServerForDimension(worldId);
		if(world != null){
			return getEntityOnServer(entityId, world);
		}
		return null;
	}

	public static Entity getEntityOnServer(int entityId, World world){
		if(world != null){
			Entity e = world.getEntityByID(entityId);
			return e;
		}
		return null;
	}
	
	@SideOnly(value = Side.CLIENT)
	public static EntityClone getCloneOnClient(int entityId){
		World world = Minecraft.getMinecraft().theWorld;
		if(world != null){
			Entity e = world.getEntityByID(entityId);
			if(e != null && e instanceof EntityClone){
				return (EntityClone)e;
			}
		}
		return null;
	}
	
	@SideOnly(value = Side.CLIENT)
	public static Entity getEntityOnClient(int entityId){
		World world = Minecraft.getMinecraft().theWorld;
		if(world != null){
			return world.getEntityByID(entityId);
		}
		return null;
	}
	
	


	
	/***
	 * Creates the appropriate Handler from the data given in the packet. Then sends it off to the Handler to be handled. duh
	 * @param manager The network manager the packet came from
	 * @param packet The packet which has been sent.
	 * @param player The player which has either sent or received the packet
	 */
	public static final void createAndUsePacket(INetworkManager manager, Packet250CustomPayload packet, Player player){
//		System.out.println("Packet");
		Side side = (packet.channel.equals("CloneCraftServer")?Side.SERVER:Side.CLIENT);
		byte[] bytes = packet.data;
		DataInputStream in = null;
		ByteArrayInputStream byteIn = null;
		try{
			byteIn = new ByteArrayInputStream(bytes);
			in = new DataInputStream(byteIn);
			int id = in.read();
			if(idToClass.containsKey(id)){
				Class c = idToClass.get(id);
				if(c != null){
					Handler handler = (Handler)c.newInstance();
					if(handler != null){
						handler.fillData(in);
						handler.handle(side, manager, (EntityPlayer)player);
					}
				}
			}
		}catch(Exception e){
			e.printStackTrace();
		}finally{
			if(in != null){
				try{
					in.close();
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
	}

	
    /***
     * The mapping between the handler classes and their given id's
     */
    static HashMap<Integer, Class> idToClass = new HashMap<Integer, Class>();
    static HashMap<Class, Integer> classToId = new HashMap<Class, Integer>();
    
    /***
     * Adds mapping for the given handler
     * @param id The id for the Handler
     * @param handlerClass The class of the Handler
     */
    public static void addMapping(int id, Class handlerClass){
    	idToClass.put(id, handlerClass);
    	classToId.put(handlerClass, id);
    }
    
    /***
     * Define all handlers here, or elsewhere if you please I guess, but here is best. :)
     */
    static{
    	addMapping(0, Handler0UpdateCentrifugeInfo.class);
    	addMapping(1, Handler1SpinCentrifuge.class);
    	addMapping(2, Handler2UpdateEntitySpawnEgg.class);
    	addMapping(3, Handler3LifeInducerUpdates.class);
    	addMapping(4, Handler4UpdateCloneValue.class);
    	addMapping(5, Handler5UpdateOneOption.class);
    	addMapping(6, Handler6UpdateAll.class);
    	addMapping(7, Handler7PleaseUpdateCloneValue.class);
    	addMapping(8, Handler8CloneClones.class);
    	addMapping(9, Handler9TransferXP.class);
    	addMapping(10, Handler10KillClone.class);
    	addMapping(11, Handler11ChangeOwner.class);
    	addMapping(12, Handler12UpdateBlock.class);
    	addMapping(13, Handler13UpdateEntity.class);
    	addMapping(14, Handler14OnEatenFood.class);
    	addMapping(15, Handler15Synchronize.class);
    	addMapping(16, Handler16UpdateGenes.class);
    	addMapping(17, Handler17TeleportPlayer.class);
    	addMapping(18, Handler18TPEffects.class);
    }
}
